pkgname =  "geocode-glib"
pkgver  = "3.26.4" 
source  = f"https://download.gnome.org/sources/geocode-glib/3.26/geocode-glib-{pkgver}.tar.xz"
builddir = f"/tmp/fempkg/build/{pkgname}/{pkgname}-{pkgver}"
fembuilddir = f"/tmp/fempkg/build/{pkgname}"
deps = ["json-glib", "libsoup", "glib"]

build = [
    # Extract
    f"mkdir /tmp/fempkg/build {fembuilddir} || true && cd {fembuilddir} && tar -xvf /var/lib/fempkg/pkgs/{pkgname}-{pkgver}.tar.xz",

    # 64-bit build
    f"cd {builddir} && mkdir build && cd build && meson setup --prefix=/usr --buildtype=release -D enable-gtk-doc=false -D soup2=false ..",
    f"cd {builddir}/build && ninja",
    f"cd {builddir}/build && ninja install",

    # Cleanup
    f"rm -rf {builddir} {fembuilddir}"
]
