pkgname =  "giflib"
pkgver  = "5.2.2" 
source  = f"https://sourceforge.net/projects/giflib/files/giflib-{pkgver}.tar.gz"
builddir = f"/tmp/fempkg/build/{pkgname}/{pkgname}-{pkgver}"
fembuilddir = f"/tmp/fempkg/build/{pkgname}"
deps = []

build = [
    # Extract
    f"mkdir /tmp/fempkg/build {fembuilddir} || true && cd {fembuilddir} && tar -xvf /var/lib/fempkg/pkgs/{pkgname}-{pkgver}.tar.gz && wget https://www.linuxfromscratch.org/patches/blfs/svn/giflib-{pkgver}-upstream_fixes-1.patch https://www.linuxfromscratch.org/patches/blfs/svn/giflib-{pkgver}-security_fixes-1.patch",

    # 64-bit build
    f"cd {builddir} && patch -Np1 -i ../giflib-{pkgver}-upstream_fixes-1.patch && patch -Np1 -i ../giflib-{pkgver}-security_fixes-1.patch && cp pic/gifgrid.gif doc/giflib-logo.gif",
    f"cd {builddir} && make -j$(nproc)",
    f"cd {builddir} && make PREFIX=/usr install && rm -fv /usr/lib/libgif.a || true && find doc $ -name Makefile\\* -o -name \\*.1 -o -name \\*.xml $ -exec rm -v {{}} \\; && install -v -dm755 /usr/share/doc/giflib-{pkgver} && install -v -dm755 /usr/share/doc/giflib-{pkgver} || true && cp -v -R doc/* /usr/share/doc/giflib-{pkgver} || true",

    # Cleanup
    f"rm -rf {builddir} {fembuilddir}"
]
