pkgname =  "git"
pkgver  = "2.51.1" 
source  = f"https://www.kernel.org/pub/software/scm/git/git-{pkgver}.tar.xz"
builddir = f"/tmp/fempkg/build/{pkgname}/{pkgname}-{pkgver}"
fembuilddir = f"/tmp/fempkg/build/{pkgname}"
deps = ["curl"]

build = [
    # Extract
    f"mkdir /tmp/fempkg/build {fembuilddir} || true && cd {fembuilddir} && tar -xvf /var/lib/fempkg/pkgs/{pkgname}-{pkgver}.tar.xz",

    # 64-bit build
    f"cd {builddir} && ./configure --prefix=/usr --with-gitconfig=/etc/gitconfig --with-python=python3 --with-libpcre2",
    f"cd {builddir} && make -j$(nproc)",
    f"cd {builddir} && make perllibdir=/usr/lib/perl5/5.42/site_perl install",

    # Cleanup
    f"rm -rf {builddir} {fembuilddir}"
]
