pkgname = "glib"
pkgver  = "2.86.1"
source  = f"https://download.gnome.org/sources/glib/2.86/glib-{pkgver}.tar.xz"
builddir = f"/tmp/fempkg/build/{pkgname}/{pkgname}-{pkgver}"
fembuilddir = f"/tmp/fempkg/build/{pkgname}"
gobject_ver = "1.86.0"
deps = []

build = [
    # Extract
    f"mkdir -p {fembuilddir}",
    f"cd {fembuilddir} && tar -xvf /var/lib/fempkg/pkgs/{pkgname}-{pkgver}.tar.xz",
    f"cd {fembuilddir} && wget https://download.gnome.org/sources/gobject-introspection/1.86/gobject-introspection-{gobject_ver}.tar.xz",
    f"cd {fembuilddir} && wget https://www.linuxfromscratch.org/patches/blfs/svn/glib-skip_warnings-1.patch",

    # 64-bit build
    f"cd {builddir} && patch -Np1 -i ../glib-skip_warnings-1.patch",
    f"cd {builddir} && if [ -e /usr/include/glib-2.0 ]; then rm -rf /usr/include/glib-2.0.old && mv -vf /usr/include/glib-2.0{{,.old}}; fi && mkdir build",
    f"cd {builddir}/build && meson setup .. --prefix=/usr --buildtype=release -D introspection=disabled -D glib_debug=disabled -D man-pages=disabled -D tests=false -D sysprof=disabled",
    f"cd {builddir}/build && ninja",
    f"cd {builddir}/build && ninja install",

    # Build GObject Introspection
    f"cd {builddir}/build && tar xf ../../gobject-introspection-{gobject_ver}.tar.xz",
    f"cd {builddir}/build && meson setup gobject-introspection-{gobject_ver} gi-build --prefix=/usr --buildtype=release",
    f"cd {builddir}/build && ninja -C gi-build",
    f"cd {builddir}/build && ninja -C gi-build install",
    f"cd {builddir}/build && meson configure -D introspection=enabled",
    f"cd {builddir}/build && ninja",
    f"cd {builddir}/build && ninja install",
    # Cleanup
    f"rm -rf {builddir} {fembuilddir}"
]
