# glibc.recipe.py
pkgname = "glibc"
pkgver = "2.42"
source = f"http://localhost:8080/glibc-{pkgver}.tar.xz"
deps = []

build = [
    # Extract tarball
    f"cd /sources && tar -xvf glibc-{pkgver}.tar.xz",

    # Apply FHS patch
    f"cd /sources/glibc-{pkgver} && patch -Np1 -i ../glibc-{pkgver}-fhs-1.patch",

    # sed fix (operate inside source tree)
    (
        f"cd /sources/glibc-{pkgver} && "
        r"sed -e '/unistd.h/i #include <string.h>' "
        r"-e '/libc_rwlock_init/c\__libc_rwlock_define_initialized (, reset_lock);\nmemcpy (&lock, &reset_lock, sizeof (lock));' "
        r"-i stdlib/abort.c"
    ),

    # Create 64-bit build dir & configure
    f"cd /sources/glibc-{pkgver} && mkdir -v build",
    f"cd /sources/glibc-{pkgver}/build && echo 'rootsbindir=/usr/sbin' > configparms",
    (
        f"cd /sources/glibc-{pkgver}/build && ../configure --prefix=/usr "
        "--disable-werror --disable-nscd libc_cv_slibdir=/usr/lib "
        "--enable-stack-protector=strong --enable-kernel=5.4"
    ),

    # Build 64-bit
    f"cd /sources/glibc-{pkgver}/build && make -j$(nproc)",

    # Run test suite (suppress failures so we can continue even with some fails)
    f"cd /sources/glibc-{pkgver}/build && make check -j$(nproc) || true",

    # Prevent the installation test script from aborting install (adjust Makefile)
    # edit the top-level Makefile (one dir up from build)
    f"cd /sources/glibc-{pkgver}/build && sed '/test-installation/s@\\$(PERL)@echo not running@' -i ../Makefile",

    # fix ldd RTLDLIST edit (as in LFS instructions)
    f"sed '/RTLDLIST=/s@/usr@@g' -i /usr/bin/ldd || true",

    # Install 64-bit
    f"cd /sources/glibc-{pkgver}/build && make install || true",

    # Install locales from the build dir (objdir must be set)
    f"cd /sources/glibc-{pkgver}/build && make localedata/install-locales || true",

    # Create nsswitch.conf (heredoc)
    """cat > /etc/nsswitch.conf << "EOF"
passwd: files
group: files
shadow: files

hosts: files dns
networks: files

protocols: files
services: files
ethers: files
rpc: files
EOF""",

    # Timezone setup: ensure ZONEINFO is exported for the whole block and run in /sourc
    # Timezone setup: ensure we stay in /sources
(
    f"cd /sources && tar -xf tzdata2025b.tar.gz && "
    "ZONEINFO=/usr/share/zoneinfo && "
    "mkdir -pv $ZONEINFO/{posix,right} && "
    "for tz in etcetera southamerica northamerica europe africa antarctica asia australasia backward; do "
    "  zic -L /dev/null -d $ZONEINFO ${tz}; "
    "  zic -L /dev/null -d $ZONEINFO/posix ${tz}; "
    "  zic -L leapseconds -d $ZONEINFO/right ${tz}; "
    "done && "
    "cp -v zone.tab zone1970.tab iso3166.tab $ZONEINFO && "
    "zic -d $ZONEINFO -p America/New_York && "
    "ln -sfv /usr/share/zoneinfo/Europe/Rome /etc/localtime"
),


    # ld.so.conf
    """cat > /etc/ld.so.conf << "EOF"
/usr/local/lib
/opt/lib
EOF""",
    "mkdir -pv /etc/ld.so.conf.d",

    # --- 32-bit Glibc build (do this inside the same build dir) ---
    # clean objdir but keep source tree
    f"cd /sources/glibc-{pkgver}/build && rm -rf ./* || true",
    f"cd /sources/glibc-{pkgver}/build && find .. -name '*.a' -delete || true",

    # configure 32-bit build from build dir (use CC/CXX -m32)
    (
        f"cd /sources/glibc-{pkgver}/build && "
        "CC=\"gcc -m32\" CXX=\"g++ -m32\" ../configure "
        "--prefix=/usr "
        "--host=i686-pc-linux-gnu "
        "--build=$(../scripts/config.guess) "
        "--libdir=/usr/lib32 "
        "--libexecdir=/usr/lib32 "
        "--disable-werror "
        "--disable-nscd "
        "libc_cv_slibdir=/usr/lib32 "
        "--enable-stack-protector=strong "
        "--enable-kernel=5.4"
    ),

    # build & install 32-bit into DESTDIR then copy files to root locations
    f"cd /sources/glibc-{pkgver}/build && make -j$(nproc) || true",
    f"cd /sources/glibc-{pkgver}/build && make DESTDIR=$PWD/DESTDIR install || true",
    f"cd /sources/glibc-{pkgver}/build && cp -a DESTDIR/usr/lib32/* /usr/lib32/ || true",
    f"cd /sources/glibc-{pkgver}/build && install -vm644 DESTDIR/usr/include/gnu/{{lib-names,stubs}}-32.h /usr/include/gnu/ || true",
    f"echo '/usr/lib32' >> /etc/ld.so.conf || true",
]



