pkgname =  "glslang"
pkgver  = "16.0.0"
source  = f"https://github.com/KhronosGroup/glslang/archive/{pkgver}/glslang-{pkgver}.tar.gz"
builddir = f"/tmp/fempkg/build/{pkgname}/{pkgname}-{pkgver}"
fembuilddir = f"/tmp/fempkg/build/{pkgname}"
deps = ["cmake", "spirv-tools"]

build = [
    # Extract
    f"mkdir /tmp/fempkg/build {fembuilddir} || true && cd {fembuilddir} && tar -xvf /var/lib/fempkg/pkgs/{pkgname}-{pkgver}.tar.gz",

    # 64-bit build
    f"cd {builddir} && mkdir build && cd build && cmake -D CMAKE_INSTALL_PREFIX=/usr -D CMAKE_BUILD_TYPE=Release -D ALLOW_EXTERNAL_SPIRV_TOOLS=ON -D BUILD_SHARED_LIBS=ON -D GLSLANG_TESTS=ON -G Ninja ..",
    f"cd {builddir}/build && ninja",
    f"cd {builddir}/build && ninja install",

    # Cleanup
    f"rm -rf {builddir} {fembuilddir}"
]
