pkgname =  "glslc"
pkgver  = "2025.4" 
source  = f"https://github.com/google/shaderc/archive/v{pkgver}/shaderc-{pkgver}.tar.gz"
builddir = f"/tmp/fempkg/build/{pkgname}/shaderc-{pkgver}"
fembuilddir = f"/tmp/fempkg/build/{pkgname}"
deps = ["cmake", "glslang", "spirv-tools"]

build = [
    # Extract
    f"mkdir /tmp/fempkg/build {fembuilddir} || true && cd {fembuilddir} && tar -xvf /var/lib/fempkg/pkgs/shaderc-{pkgver}.tar.gz",

    # 64-bit build
    f"cd {builddir} && sed '/build-version/d' -i glslc/CMakeLists.txt && sed '/third_party/d' -i CMakeLists.txt && sed 's|SPIRV|glslang/&|' -i libshaderc_util/src/compiler.cc && echo '\"{pkgver}\"' > glslc/src/build-version.inc && mkdir build && cd build && cmake -D CMAKE_INSTALL_PREFIX=/usr -D CMAKE_BUILD_TYPE=Release -D SHADERC_SKIP_TESTS=ON -G Ninja ..",
    f"cd {builddir}/build && ninja",
    f"cd {builddir}/build && install -vm755 glslc/glslc /usr/bin",

    # Cleanup
    f"rm -rf {builddir} {fembuilddir}"
]
