pkgname =  "glu"
pkgver  = "9.0.3" 
source  = f"https://archive.mesa3d.org/glu/glu-{pkgver}.tar.xz"
builddir = f"/tmp/fempkg/build/{pkgname}/{pkgname}-{pkgver}"
fembuilddir = f"/tmp/fempkg/build/{pkgname}"
deps = ["mesa"]

build = [
    # Extract
    f"mkdir /tmp/fempkg/build {fembuilddir} || true && cd {fembuilddir} && tar -xvf /var/lib/fempkg/pkgs/{pkgname}-{pkgver}.tar.xz",

    # 64-bit build
    f"cd {builddir} && mkdir build && cd build && meson setup .. --prefix=/usr -D gl_provider=gl --buildtype=release",
    f"cd {builddir}/build && ninja",
    f"cd {builddir}/build && ninja install && rm -vf /usr/lib/libGLU.a",

    # Cleanup
    f"rm -rf {builddir} {fembuilddir}"
]
