# gmp.recipe.py
pkgname = "gmp"
pkgver  = "6.3.0"
source  = f"http://localhost:8080/{pkgname}-{pkgver}.tar.xz"

deps = []

build = [
    # Extract
    f"cd /sources && tar -xvf {pkgname}-{pkgver}.tar.xz",

    # 64-bit build
    f"cd /sources/{pkgname}-{pkgver} && sed -i '/long long t1;/,+1s/()/(...)/' configure",
    f"cd /sources/{pkgname}-{pkgver} && ./configure --prefix=/usr --enable-cxx --host=none-linux-gnu --disable-static --docdir=/usr/share/doc/gmp-{pkgver}",
    f"cd /sources/{pkgname}-{pkgver} && make -j$(nproc)",
    f"cd /sources/{pkgname}-{pkgver} && make html",
    f"cd /sources/{pkgname}-{pkgver} && make check || true",
    f"cd /sources/{pkgname}-{pkgver} && make install && make install html",

    # 32 bit
    f"cd /sources/{pkgname}-{pkgver} && make distclean",
    f"cd /sources/{pkgname}-{pkgver} && cp -v configfsf.guess config.guess",
    f"cd /sources/{pkgname}-{pkgver} && cp -v configfsf.sub   config.sub",
    f"cd /sources/{pkgname}-{pkgver} && ABI=\"32\" CFLAGS=\"-m32 -O2 -pedantic -fomit-frame-pointer -mtune=generic -march=i686\" CXXFLAGS=\"$CFLAGS\" PKG_CONFIG_PATH=\"/usr/lib32/pkgconfig\" ./configure --host=i686-pc-linux-gnu --prefix=/usr --disable-static --enable-cxx --libdir=/usr/lib32 --includedir=/usr/include/m32/gmp",
    f"cd /sources/{pkgname}-{pkgver} && sed -i 's/$(exec_prefix)\/include/$\(includedir\)/' Makefile",
    f"cd /sources/{pkgname}-{pkgver} && make -j$(nproc)",
    f"cd /sources/{pkgname}-{pkgver} && make check || true",
    f"cd /sources/{pkgname}-{pkgver} && make DESTDIR=$PWD/DESTDIR install",
    f"cd /sources/{pkgname}-{pkgver} && cp -Rv DESTDIR/usr/lib32/* /usr/lib32",
    f"cd /sources/{pkgname}-{pkgver} && cp -Rv DESTDIR/usr/include/m32/* /usr/include/m32/",
    f"cd /sources/{pkgname}-{pkgver} && rm -rf DESTDIR"

    # Cleanup
    f"rm -rf /sources/{pkgname}-{pkgver}"
]
