pkgname =  "gnome-keyring"
pkgver  = "48.0" 
source  = f"https://download.gnome.org/sources/gnome-keyring/48/gnome-keyring-{pkgver}.tar.xz"
builddir = f"/tmp/fempkg/build/{pkgname}/{pkgname}-{pkgver}"
fembuilddir = f"/tmp/fempkg/build/{pkgname}"
deps = ["dbus", "gcr", "Linux-PAM", "ssh"]

build = [
    # Extract
    f"mkdir /tmp/fempkg/build {fembuilddir} || true && cd {fembuilddir} && tar -xvf /var/lib/fempkg/pkgs/{pkgname}-{pkgver}.tar.xz",

    # 64-bit build
    f"cd {builddir} && sed -i 's:\"/desktop:\"/org:' schema/*.xml && mkdir build-gkr && cd build-gkr && meson setup .. --prefix=/usr --buildtype=release -D systemd=disabled -D ssh-agent=true",
    f"cd {builddir}/build-gkr && ninja",
    f"cd {builddir}/build-gkr && ninja install",

    # Cleanup
    f"rm -rf {builddir} {fembuilddir}"
]
