pkgname =  "gnome-settings-daemon"
pkgver  = "48.1" 
source  = f"https://download.gnome.org/sources/gnome-settings-daemon/48/gnome-settings-daemon-{pkgver}.tar.xz"
builddir = f"/tmp/fempkg/build/{pkgname}/{pkgname}-{pkgver}"
fembuilddir = f"/tmp/fempkg/build/{pkgname}"
deps = ["alsa-lib", "fontconfig", "libsecret", "gnome-keyring", "gcr4", "geoclue", "geocode-glib", "gnome-desktop", "libcanberra", "libgweather", "libnotify", "libwacom", "pulseaudio", "upower",  "NetworkManager", "wayland"]

build = [
    # Extract
    f"mkdir /tmp/fempkg/build {fembuilddir} || true && cd {fembuilddir} && tar -xvf /var/lib/fempkg/pkgs/{pkgname}-{pkgver}.tar.xz",

    # 64-bit build
    f"cd {builddir} && sed -e 's/libsystemd/libelogind/' -i plugins/power/test.py && sed -e 's/(backlight->logind_proxy)/(0)/' -i plugins/power/gsd-backlight.c && mkdir build && cd build && meson setup --prefix=/usr --buildtype=release -D systemd=false -D cups=false -D colord=false ..",
    f"cd {builddir}/build && ninja",
    f"cd {builddir}/build && ninja install",

    # Cleanup
    f"rm -rf {builddir} {fembuilddir}"
]
