pkgname =  "gnutls"
pkgver  = "3.8.10" 
source  = f"https://www.gnupg.org/ftp/gcrypt/gnutls/v3.8/gnutls-{pkgver}.tar.xz"
builddir = f"/tmp/fempkg/build/{pkgname}/{pkgname}-{pkgver}"
fembuilddir = f"/tmp/fempkg/build/{pkgname}"
deps = ["nettle", "libunistring", "libtasn1", "p11-kit"]

build = [
    # Extract
    f"mkdir /tmp/fempkg/build {fembuilddir} || true && cd {fembuilddir} && tar -xvf /var/lib/fempkg/pkgs/{pkgname}-{pkgver}.tar.xz",

    # 64-bit build
    f"cd {builddir} && ./configure --prefix=/usr --docdir=/usr/share/doc/gnutls-3.8.10 --with-default-trust-store-pkcs11=\"pkcs11:\"",
    f"cd {builddir} && make -j$(nproc)",
    f"cd {builddir} && make install",

    # Cleanup
    f"rm -rf {builddir} {fembuilddir}"
]
