pkgname =  "gpg"
pkgver  = "2.4.8" 
source  = f"https://www.gnupg.org/ftp/gcrypt/gnupg/gnupg-{pkgver}.tar.bz2"
builddir = f"/tmp/fempkg/build/{pkgname}/gnupg-{pkgver}"
fembuilddir = f"/tmp/fempkg/build/{pkgname}"
deps = ["libassuan", "libgcrypt", "gnutls", "libksba", "openldap"]

build = [
    # Extract
    f"mkdir /tmp/fempkg/build {fembuilddir} || true && cd {fembuilddir} && tar -xvf /var/lib/fempkg/pkgs/gnupg-{pkgver}.tar.bz2",

    # 64-bit build
    f"cd {builddir} && mkdir build && cd build && ../configure --prefix=/usr --localstatedir=/var --sysconfdir=/etc --docdir=/usr/share/doc/gnupg-{pkgver}",
    f"cd {builddir}/build && make && makeinfo --html --no-split -I doc -o doc/gnupg_nochunks.html ../doc/gnupg.texi && makeinfo --plaintext -I doc -o doc/gnupg.txt ../doc/gnupg.texi && make -C doc html -j$(nproc)",
    f"cd {builddir}/build && make install && install -v -m755 -d /usr/share/doc/gnupg-{pkgver}/html && install -v -m644 doc/gnupg_nochunks.html /usr/share/doc/gnupg-{pkgver}/html/gnupg.html && install -v -m644 ../doc/*.texi doc/gnupg.txt /usr/share/doc/gnupg-{pkgver} && install -v -m644 doc/gnupg.html/* /usr/share/doc/gnupg-{pkgver}/html",

    # Cleanup
    f"rm -rf {builddir} {fembuilddir}"
]
