pkgname =  "gpgme"
pkgver  = "2.0.1" 
source  = f"https://www.gnupg.org/ftp/gcrypt/gpgme/gpgme-{pkgver}.tar.bz2"
builddir = f"/tmp/fempkg/build/{pkgname}/{pkgname}-{pkgver}"
fembuilddir = f"/tmp/fempkg/build/{pkgname}"
deps = ["libassuan"]

build = [
    # Extract
    f"mkdir /tmp/fempkg/build {fembuilddir} || true && cd {fembuilddir} && tar -xvf /var/lib/fempkg/pkgs/{pkgname}-{pkgver}.tar.bz2",

    # 64-bit build
    f"cd {builddir} && mkdir build && cd build && ../configure --prefix=/usr --disable-static --disable-gpg-test",
    f"cd {builddir}/build && make -j$(nproc)",
    f"cd {builddir}/build && make install",

    # Cleanup
    f"rm -rf {builddir} {fembuilddir}"
]
