pkgname =  "grub"
pkgver  = "2.12" 
source  = f"http://localhost:8080/{pkgname}-{pkgver}.tar.xz"

deps = []

build = [
    # Extract
    f"cd /sources && tar -xvf {pkgname}-{pkgver}.tar.xz",

    # 64-bit build
    f"cd /sources/{pkgname}-{pkgver} && unset {{C,CPP,CXX,LD}}FLAGS && echo depends bli part_gpt > grub-core/extra_deps.lst",
    f"cd /sources/{pkgname}-{pkgver} && unset {{C,CPP,CXX,LD}}FLAGS && ./configure --prefix=/usr --sysconfdir=/etc --disable-efiemu --with-platform=efi --target=x86_64 --disable-werror",
    f"cd /sources/{pkgname}-{pkgver} && unset {{C,CPP,CXX,LD}}FLAGS && make -j$(nproc)",
    f"cd /sources/{pkgname}-{pkgver} && unset {{C,CPP,CXX,LD}}FLAGS && make install",
    f"cd /sources/{pkgname}-{pkgver} && unset {{C,CPP,CXX,LD}}FLAGS && mv -v /etc/bash_completion.d/grub /usr/share/bash-completion/completions || true",

    # Cleanup
    f"rm -rf /sources/{pkgname}-{pkgver}"
]
