pkgname =  "gsettings-desktop-schemas"
pkgver  = "49.1" 
source  = f"https://download.gnome.org/sources/gsettings-desktop-schemas/49/gsettings-desktop-schemas-{pkgver}.tar.xz"
builddir = f"/tmp/fempkg/build/{pkgname}/{pkgname}-{pkgver}"
fembuilddir = f"/tmp/fempkg/build/{pkgname}"
deps = ["glib"]

build = [
    # Extract
    f"mkdir /tmp/fempkg/build {fembuilddir} || true && cd {fembuilddir} && tar -xvf /var/lib/fempkg/pkgs/{pkgname}-{pkgver}.tar.xz",

    # 64-bit build
    f"cd {builddir} && sed -i -r 's:\"(/system):\"/org/gnome\1:g' schemas/*.in",
    f"cd {builddir} && mkdir build && cd build && meson setup --prefix=/usr --buildtype=release ..",
    f"cd {builddir}/build && ninja",
    f"cd {builddir}/build && ninja install",
    
    # Cleanup
    f"rm -rf {builddir} {fembuilddir}"
]
