pkgname =  "gst-plugins-base"
pkgver  = "1.26.6" 
source  = f"https://gstreamer.freedesktop.org/src/gst-plugins-base/gst-plugins-base-{pkgver}.tar.xz"
builddir = f"/tmp/fempkg/build/{pkgname}/{pkgname}-{pkgver}"
fembuilddir = f"/tmp/fempkg/build/{pkgname}"
deps = ["gstreamer", "glib", "libgudev", "libvorbis", "mesa", "pango", "wayland-protocols", "xorg-libs"]

build = [
    # Extract
    f"mkdir /tmp/fempkg/build {fembuilddir} || true && cd {fembuilddir} && tar -xvf /var/lib/fempkg/pkgs/{pkgname}-{pkgver}.tar.xz",

    # 64-bit build
    f"cd {builddir} && mkdir build && cd build && meson setup .. --prefix=/usr --buildtype=release --wrap-mode=nodownload",
    f"cd {builddir}/build && ninja",
    f"cd {builddir}/build && ninja install",

    # Cleanup
    f"rm -rf {builddir} {fembuilddir}"
]
