pkgname =  "gstreamer"
pkgver  = "1.26.6" 
source  = f"https://gstreamer.freedesktop.org/src/gstreamer/gstreamer-{pkgver}.tar.xz"
builddir = f"/tmp/fempkg/build/{pkgname}/{pkgname}-{pkgver}"
fembuilddir = f"/tmp/fempkg/build/{pkgname}"
deps = ["glib"]

build = [
    # Extract
    f"mkdir /tmp/fempkg/build {fembuilddir} || true && cd {fembuilddir} && tar -xvf /var/lib/fempkg/pkgs/{pkgname}-{pkgver}.tar.xz",

    # 64-bit build
    f"cd {builddir} && mkdir build && cd build && meson setup .. --prefix=/usr --buildtype=release -D gst_debug=true",
    f"cd {builddir}/build && ninja",
    f"cd {builddir}/build && rm -rf /usr/bin/gst-* /usr/{{lib,libexec}}/gstreamer-1.0 || true && ninja install",

    # Cleanup
    f"rm -rf {builddir} {fembuilddir}"
]
