pkgname =  "gtk3"
pkgver  = "3.24.51" 
source  = f"https://download.gnome.org/sources/gtk/3.24/gtk-{pkgver}.tar.xz"
builddir = f"/tmp/fempkg/build/{pkgname}/gtk-{pkgver}"
fembuilddir = f"/tmp/fempkg/build/{pkgname}"
deps = ["atspi2core", "gdkpixbuf", "libepoxy", "pango", "libxkbcommon"]

build = [
    # Extract
    f"mkdir /tmp/fempkg/build {fembuilddir} || true && cd {fembuilddir} && tar -xvf /var/lib/fempkg/pkgs/gtk-{pkgver}.tar.xz",

    # 64-bit build
    f"cd {builddir} && mkdir build && cd build && meson setup .. --prefix=/usr --buildtype=release -D man=true -D broadway_backend=true",
    f"cd {builddir}/build && ninja",
    f"cd {builddir}/build && ninja install",

    # Cleanup
    f"rm -rf {builddir} {fembuilddir}"
]
