pkgname =  "gtk4"
pkgver  = "4.20.2" 
source  = f"https://download.gnome.org/sources/gtk/4.20/gtk-{pkgver}.tar.xz"
builddir = f"/tmp/fempkg/build/{pkgname}/gtk-{pkgver}"
fembuilddir = f"/tmp/fempkg/build/{pkgname}"
deps = ["gdkpixbuf", "graphene", "iso-codes", "libepoxy", "libxkbcommon", "pango", "pygobject", "wayland-protocols", "glib", "glslc", "webrtc-audio-processing"]

build = [
    # Extract
    f"mkdir /tmp/fempkg/build {fembuilddir} || true && cd {fembuilddir} && tar -xvf /var/lib/fempkg/pkgs/gtk-{pkgver}.tar.xz",

    # 64-bit build
    f"cd {builddir} && mkdir build && cd build && meson setup --prefix=/usr --buildtype=release -D broadway-backend=true -D introspection=enabled -D vulkan=enabled ..",
    f"cd {builddir}/build && ninja",
    f"cd {builddir}/build && ninja install",

    # Cleanup
    f"rm -rf {builddir} {fembuilddir}"
]
