pkgname =  "gtkmm4"
pkgver  = "4.20.0" 
source  = f"https://download.gnome.org/sources/gtkmm/4.20/gtkmm-{pkgver}.tar.xz"
builddir = f"/tmp/fempkg/build/{pkgname}/gtkmm-{pkgver}"
fembuilddir = f"/tmp/fempkg/build/{pkgname}"
deps = ["gtk4", "pangomm"]

build = [
    # Extract
    f"mkdir /tmp/fempkg/build {fembuilddir} || true && cd {fembuilddir} && tar -xvf /var/lib/fempkg/pkgs/gtkmm-{pkgver}.tar.xz",

    # 64-bit build
    f"cd {builddir} && mkdir build && cd build && meson setup --prefix=/usr --buildtype=release ..",
    f"cd {builddir}/build && ninja",
    f"cd {builddir}/build && ninja install",

    # Cleanup
    f"rm -rf {builddir} {fembuilddir}"
]
