pkgname =  "harfbuzz"
pkgver  = "12.1.0" 
source  = f"https://github.com/harfbuzz/harfbuzz/releases/download/{pkgver}/harfbuzz-{pkgver}.tar.xz"
builddir = f"/tmp/fempkg/build/{pkgname}/{pkgname}-{pkgver}"
fembuilddir = f"/tmp/fempkg/build/{pkgname}"
deps = ["glib", "icu"]

build = [
    # Extract
    f"mkdir /tmp/fempkg/build {fembuilddir} || true && cd {fembuilddir} && tar -xvf /var/lib/fempkg/pkgs/{pkgname}-{pkgver}.tar.xz",

    # 64-bit build
    f"cd {builddir} && mkdir -v build",
    f"cd {builddir}/build && meson setup .. --prefix=/usr --buildtype=release -D graphite2=disabled",
    f"cd {builddir}/build && ninja",
    f"cd {builddir}/build && ninja install",


    # Cleanup
    f"rm -rf {builddir} {fembuilddir}"
]
