pkgname =  "hatchling"
pkgver  = "1.27.0" 
source  = f"https://files.pythonhosted.org/packages/source/h/hatchling/hatchling-{pkgver}.tar.gz"
builddir = f"/tmp/fempkg/build/{pkgname}/{pkgname}-{pkgver}"
fembuilddir = f"/tmp/fempkg/build/{pkgname}"
deps = ["editables", "pathspec", "pluggy", "trove_classifiers"]

build = [
    # Extract
    f"mkdir /tmp/fempkg/build {fembuilddir} || true && cd {fembuilddir} && tar -xvf /var/lib/fempkg/pkgs/{pkgname}-{pkgver}.tar.gz",

    # 64-bit build
    f"cd {builddir} && pip3 wheel -w dist --no-build-isolation --no-cache-dir $PWD",
    f"cd {builddir} && pip3 install --no-index --find-links dist --no-user hatchling",

    # Cleanup
    f"rm -rf {builddir} {fembuilddir}"
]
