pkgname =  "hyprland-libs"
pkgver  = "0.51.1" 
source  = f"https://github.com/hyprwm/Hyprland/releases/download/v{pkgver}/source-v{pkgver}.tar.gz"
builddir = f"/tmp/fempkg/build/{pkgname}/hyprland-source"
fembuilddir = f"/tmp/fempkg/build/{pkgname}"
deps = [
    "cairo", "cmake", "mesa", "libdisplay-info", "libdrm", "libinput",
    "libjxl", "libpng", "librsvg", "libwebp", "libzip", "libglvnd", "pixman",
    "pugixml", "qt6", "seatd", "tomlplusplus", "wayland", "wayland-protocols", "hwdata"
]

build = [
    # Extract
    f"mkdir -p /tmp/fempkg/build {fembuilddir} && cd {fembuilddir} && tar -xvf /var/lib/fempkg/pkgs/source-v{pkgver}.tar.gz",

    # Fetch libs
    f"""cd {builddir} && cat > hypr-list << "EOF"
hyprland-protocols/archive/v0.7.0/hyprland-protocols-v0.7.0.tar.gz
hyprutils/archive/v0.10.0/hyprutils-v0.10.0.tar.gz
hyprlang/archive/v0.6.4/hyprlang-v0.6.4.tar.gz
hyprcursor/archive/v0.1.13/hyprcursor-v0.1.13.tar.gz
hyprwayland-scanner/archive/v0.4.5/hyprwayland-scanner-v0.4.5.tar.gz
aquamarine/archive/v0.9.5/aquamarine-v0.9.5.tar.gz
hyprgraphics/archive/v0.2.0/hyprgraphics-v0.2.0.tar.gz
hyprland-qt-support/archive/v0.1.0/hyprland-qt-support-v0.1.0.tar.gz
hyprland-qtutils/archive/v0.1.5/hyprland-qtutils-v0.1.5.tar.gz
EOF
""",
    f"cd {builddir} && mkdir hyprlib && cd hyprlib && grep -v '^#' ../hypr-list | wget -i- -c -B https://github.com/hyprwm/",

    # Build libs loop
    f"""cd {builddir}/hyprlib && bash -c '
as_root() {{
  if   [ $EUID = 0 ];        then "$@"
  elif [ -x /usr/bin/sudo ]; then sudo "$@"
  else                            su -c "$*"
  fi
}}
export -f as_root

for package in $(grep -v '^#' ../hypr-list); do
  package=$(basename "$package")
  packagedir=${{package%.tar.?z*}}
  packagedir=$(echo -n "$packagedir" | sed "s/-v\\([0-9]\\)/-\\1/")
  echo "Building $packagedir"

  tar -xf "$package"
  pushd "$packagedir"

  case $packagedir in
    hyprland-protocols-[0-9]* )
      mkdir build && cd build
      meson setup --prefix=/usr ..
    ;;

    hyprland-qt-support-[0-9]* )
      mkdir build && cd build
      cmake -D CMAKE_INSTALL_PREFIX=/usr       \\
            -D CMAKE_BUILD_TYPE=Release        \\
            -D CMAKE_SKIP_INSTALL_RPATH=ON     \\
            -D INSTALL_QML_PREFIX=/lib/qt6/qml \\
            ..
      make
      as_root make install
      popd
      rm -rf "$packagedir"
      as_root /sbin/ldconfig
      continue
    ;;

    * )
      mkdir build && cd build
      cmake -D CMAKE_INSTALL_PREFIX=/usr   \\
            -D CMAKE_BUILD_TYPE=Release    \\
            -D CMAKE_SKIP_INSTALL_RPATH=ON \\
            -G Ninja ..
    ;;
  esac

  ninja
  as_root ninja install
  popd
  rm -rf "$packagedir"
  as_root /sbin/ldconfig
done
'""",

    # Cleanup
    f"rm -rf {builddir} {fembuilddir}"
]
