pkgname =  "hyprland"
pkgver  = "0.51.1" 
source  = f"https://github.com/hyprwm/Hyprland/releases/download/v{pkgver}/source-v{pkgver}.tar.gz"
builddir = f"/tmp/fempkg/build/{pkgname}/hyprland-source"
fembuilddir = f"/tmp/fempkg/build/{pkgname}"
deps = [
    "cairo", "cmake", "mesa", "libdisplay-info", "libdrm", "libinput",
    "libjxl", "libpng", "librsvg", "libwebp", "libzip", "libglvnd", "pixman",
    "pugixml", "qt6", "seatd", "tomlplusplus", "wayland", "wayland-protocols", "hwdata",
    "glaze", "libliftoff", "re2", "xcb-util-errors", "xwayland", "cpio"
]

build = [
    # Extract
    f"mkdir /tmp/fempkg/build {fembuilddir} || true && cd {fembuilddir} && tar -xvf /var/lib/fempkg/pkgs/source-v{pkgver}.tar.gz",

    # 64-bit build
#    f"cd {builddir} && tar -xf ../udis86-5336633af70f3917760a6d441ff02d93477b0c86.tar.gz && mv -T udis86-5336633af70f3917760a6d441ff02d93477b0c86 subprojects/udis86",
    f"cd {builddir} && mkdir build && cd build && cmake -DCMAKE_INSTALL_PREFIX=/usr -DCMAKE_BUILD_TYPE=Release -DCMAKE_SKIP_INSTALL_RPATH=ON -W no-dev -G Ninja .. && ninja",
    f"cd {builddir}/build && ninja install",
    f"""cd {builddir} && cat > /usr/share/wayland-sessions/hyprland.desktop << EOF
[Desktop Entry]
Name=Hyprland
Comment=An intelligent dynamic tiling Wayland compositor
Exec=dbus-launch --sh-syntax Hyprland
Type=Application
DesktopNames=Hyprland
Keywords=tiling;wayland;compositor;
EOF""",
    f"cd {builddir} && sudo chmod 644 /usr/share/wayland-sessions/hyprland.desktop",
    # Cleanup
    f"rm -rf {builddir} {fembuilddir}"
]
