pkgname =  "intelmedia"
pkgver  = "25.3.4" 
source  = f"https://github.com/lfs-book/intel-media-driver/archive/v{pkgver}/intel-media-driver-{pkgver}.tar.gz"
builddir = f"/tmp/fempkg/build/{pkgname}/intel-media-driver-{pkgver}"
fembuilddir = f"/tmp/fempkg/build/{pkgname}"
deps = ["libva", "cmake", "gmmlib"]

build = [
    # Extract
    f"mkdir /tmp/fempkg/build {fembuilddir} || true && cd {fembuilddir} && tar -xvf /var/lib/fempkg/pkgs/intel-media-driver-{pkgver}.tar.gz",

    # 64-bit build
    f"cd {builddir} && mkdir -v build && cd build && cmake -D CMAKE_INSTALL_PREFIX=/usr -D CMAKE_POLICY_VERSION_MINIMUM=3.5 -D INSTALL_DRIVER_SYSCONF=OFF -D BUILD_TYPE=Release -D MEDIA_BUILD_FATAL_WARNINGS=OFF -G Ninja -W no-dev ..",
    f"cd {builddir}/build && ninja",
    f"cd {builddir}/build && ninja install",

    # Cleanup
    f"rm -rf {builddir} {fembuilddir}"
]
