pkgname =  "iproute2"
pkgver  = "6.17.0" 
source  = f"https://www.kernel.org/pub/linux/utils/net/iproute2/iproute2-{pkgver}.tar.xz"
builddir = f"/tmp/fempkg/build/{pkgname}/{pkgname}-{pkgver}"
fembuilddir = f"/tmp/fempkg/build/{pkgname}"

deps = []

build = [
    # Extract
    f"mkdir /tmp/fempkg/build {fembuilddir} || true && cd {fembuilddir} && tar -xvf /var/lib/fempkg/pkgs/{pkgname}-{pkgver}.tar.xz",

    # 64-bit build
    f"cd {builddir} && sed -i /ARPD/d Makefile ",
    f"cd {builddir} && rm -fv man/man8/arpd.8",
    f"cd {builddir} && make NETNS_RUN_DIR=/run/netns -j$(nproc)",
    f"cd {builddir} && make SBINDIR=/usr/sbin install",

    # Cleanup
    f"rm -rf {fembuilddir}"
]
