# mpc.recipe.py
pkgname = "isl"
pkgver  = "0.27"
source  = f"http://localhost:8080/{pkgname}-{pkgver}.tar.xz"

deps = []

build = [
    # Extract
    f"cd /sources && tar -xvf {pkgname}-{pkgver}.tar.xz",
    # 64-bit build
    f"cd /sources/{pkgname}-{pkgver} && ./configure --prefix=/usr --disable-static --docdir=/usr/share/doc/isl-{pkgver}",
    f"cd /sources/{pkgname}-{pkgver} && make -j$(nproc)",
    f"cd /sources/{pkgname}-{pkgver} && make install",
    f"cd /sources/{pkgname}-{pkgver} && install -vd /usr/share/doc/isl-{pkgver}",
    f"cd /sources/{pkgname}-{pkgver} && install -m644 doc/{{CodingStyle,manual.pdf,SubmittingPatches,user.pod}} /usr/share/doc/isl-{pkgver}",
    f"cd /sources/{pkgname}-{pkgver} && mkdir -pv /usr/share/gdb/auto-load/usr/lib && mv -v /usr/lib/libisl*gdb.py /usr/share/gdb/auto-load/usr/lib",

    # Cleanup
    f"rm -rf /sources/{pkgname}-{pkgver}"
]
