pkgname =  "kbd"
pkgver  = "2.9.0" 
source  = f"https://www.kernel.org/pub/linux/utils/kbd/kbd-{pkgver}.tar.xz"
builddir = f"/tmp/fempkg/build/{pkgname}/{pkgname}-{pkgver}"
fembuilddir = f"/tmp/fempkg/build/{pkgname}"
deps = []

build = [
    # Extract
    f"mkdir /tmp/fempkg/build {fembuilddir} || true && cd {fembuilddir} && tar -xvf /var/lib/fempkg/pkgs/{pkgname}-{pkgver}.tar.xz && wget https://www.linuxfromscratch.org/patches/lfs/development/kbd-{pkgver}-backspace-1.patch",

    # 64-bit build
    f"cd {builddir} && patch -Np1 -i ../kbd-{pkgver}-backspace-1.patch",
    f"cd {builddir} && sed -i '/RESIZECONS_PROGS=/s/yes/no/' configure",
    f"cd {builddir} && sed -i 's/resizecons.8 //' docs/man/man8/Makefile.in",
    f"cd {builddir} && ./configure --prefix=/usr --disable-vlock",
    f"cd {builddir} && make -j$(nproc)",
    f"cd {builddir} && make install",

    # Cleanup
    f"rm -rf {fembuilddir}"
]
