pkgname =  "kf6"
pkgver  = "6.17.0" 
source  = f"https://download.kde.org/stable/frameworks/6.17/attica-6.17.0.tar.xz"
bbuilddir = f"/tmp/fempkg/build/{pkgname}/attica-{pkgver}"
builddir = f"{bbuilddir}/kf6"
fembuilddir = f"/tmp/fempkg/build/{pkgname}"
deps = ["extra-cmake-modules", "breeze-icons", "libcanberra", "libgcrypt", "libical", "lmdb", "qca", "libqrencode", "plasma-wayland-protocols", "pyyaml", "shared-mime-info", "URI", "wget"]

build = [
    # Extract
    f"mkdir /tmp/fempkg/build {fembuilddir} || true && cd {fembuilddir} && tar -xvf /var/lib/fempkg/pkgs/attica-{pkgver}.tar.xz && mkdir {builddir}",

    # 64-bit build
    f"cd {builddir} && export url=https://download.kde.org/stable/frameworks/6.17/ && wget -r -nH -nd -A '*.xz' -np $url",
    f"""cd {builddir} && cat > frameworks-6.17.0.md5 << "EOF"
82423c1b42100b5b776c8fecdc042a40  attica-6.17.0.tar.xz
#c6c6e39f1bba551a21401cd5fbba1c1a  extra-cmake-modules-6.17.0.tar.xz
8a59548faa1778cef7a6ad3395490ed2  kapidox-6.17.0.tar.xz
7ac1e1b5d4be693f208381b4fa704965  karchive-6.17.0.tar.xz
77d7969cda44acc3c679f230d2a82f9d  kcodecs-6.17.0.tar.xz
51d38c6aec7f6af07bd0fff8c96b3505  kconfig-6.17.0.tar.xz
0e497f3da6780a81eebadd22c856bc00  kcoreaddons-6.17.0.tar.xz
4ae23e5cba7f547e5202e5eeb1842f49  kdbusaddons-6.17.0.tar.xz
cbd3e5128e0cdcdb8096d54579601bb7  kdnssd-6.17.0.tar.xz
f33a5c69a7649ffba69a1aa52feaf649  kguiaddons-6.17.0.tar.xz
4c75596dc00ad12e9a80bf7798d9f843  ki18n-6.17.0.tar.xz
e86f50568a3303f2542db2b4fb5183db  kidletime-6.17.0.tar.xz
4b291a60f6374f96e2cf99a38ddb5eb9  kimageformats-6.17.0.tar.xz
4aca52e11e671da59d87c24de5206055  kitemmodels-6.17.0.tar.xz
e01dc3235328a28275f9b6f30d915a60  kitemviews-6.17.0.tar.xz
c1afe10db53a7f061364bb8be10fc451  kplotting-6.17.0.tar.xz
238a7cb973629f9d6207fbd80e3a2a43  kwidgetsaddons-6.17.0.tar.xz
9a8e56599a0bfa0fd5ca8f52c04dd410  kwindowsystem-6.17.0.tar.xz
a999ecf34d2a08ddf9de8d1ef6b00930  networkmanager-qt-6.17.0.tar.xz
8c8239af3e50c7ae75c51292e077307d  solid-6.17.0.tar.xz
38b1c0354ca13efb9378c9a9f7ca6d4c  sonnet-6.17.0.tar.xz
1dea5634f166937e9657defd8a1c435a  threadweaver-6.17.0.tar.xz
c1c4bdcd93a64b424938efd31994b391  kauth-6.17.0.tar.xz
164f867d80ea9d511d120a2316e2d083  kcompletion-6.17.0.tar.xz
9bbc4d738ffcdb2980b7d03483f0ecaf  kcrash-6.17.0.tar.xz
318b37f959efb7b8414fd6f225fc6180  kdoctools-6.17.0.tar.xz
b53d98281af63012844e42f4d2340e72  kpty-6.17.0.tar.xz
81260390604d84f30fc7e397f2a71377  kunitconversion-6.17.0.tar.xz
e178d79bf39b6eca3c5a43904e1e6812  kcolorscheme-6.17.0.tar.xz
288b6d923b1e0e470902226cb0150aef  kconfigwidgets-6.17.0.tar.xz
bdec608acd77463bc13be706143e1ad1  kservice-6.17.0.tar.xz
bc8d0c1a7915679d265996c3f8cf022d  kglobalaccel-6.17.0.tar.xz
71aced57987eecd1a54cd78c4acf0997  kpackage-6.17.0.tar.xz
e4e7130dbc3df657419a41b1716fae88  kdesu-6.17.0.tar.xz
973fc15005119c8206deac1e7c950928  kiconthemes-6.17.0.tar.xz
7d2f8797d6a7d01481ccaa5853853f78  knotifications-6.17.0.tar.xz
1281a859bbade7b6d0f4062be5801503  kjobwidgets-6.17.0.tar.xz
a7241f89698eef4da4476c5f8e942532  ktextwidgets-6.17.0.tar.xz
f081efe2093e1808ec936a1504aa921b  kxmlgui-6.17.0.tar.xz
d9e0be9f6ab3a826d46bd69fab5df3cc  kbookmarks-6.17.0.tar.xz
be6b34cd7395ce1bfbb026202a0fb049  kwallet-6.17.0.tar.xz
ade7d92808bcc51303aac1e3d2fac1ea  kded-6.17.0.tar.xz
6f2caa8f5cc4c473c14024ef33292aa6  kio-6.17.0.tar.xz
af1144caf162a8e7183178b9697d4b76  kdeclarative-6.17.0.tar.xz
75a1a1af5647ef5ae2a4800bd5d0436e  kcmutils-6.17.0.tar.xz
9c3167fb2f81a610149d0baa9086cd03  kirigami-6.17.0.tar.xz
eefe9fd856c0d90c8e70c36cf8d71b0b  syndication-6.17.0.tar.xz
3315f351aac4fd66d1be6783d25f767b  knewstuff-6.17.0.tar.xz
58f3a8d01b2471487b5e1fee5d7428d7  frameworkintegration-6.17.0.tar.xz
b58edde459f7df84e6ac15b8c0d8a0b3  kparts-6.17.0.tar.xz
c9b97c254e572760633966017640447d  syntax-highlighting-6.17.0.tar.xz
00047f9c145d242212cf7e0bdbdd11c5  ktexteditor-6.17.0.tar.xz
c155065874518609dd0ca9159e03ee2f  modemmanager-qt-6.17.0.tar.xz
cc4c525dff89bdb2f65e3130df58e280  kcontacts-6.17.0.tar.xz
ddbcacdc97fcac94fc23624f8d86b3cd  kpeople-6.17.0.tar.xz
cff7e94d07346f8fe0863ab4140965d1  bluez-qt-6.17.0.tar.xz
07374ffc535818d174f3b2a477935c74  kfilemetadata-6.17.0.tar.xz
5f352802358f0106418a233379e6f67a  baloo-6.17.0.tar.xz
#9aaed8b97970adf982f732e528050aca  breeze-icons-6.17.0.tar.xz
3c04c64a88d1273856b9dfca5b31e787  krunner-6.17.0.tar.xz
051d08b46b47d9f79266f8c54f67ddc3  prison-6.17.0.tar.xz
1fc84041ca6959adf18aeb6f7f16519e  qqc2-desktop-style-6.17.0.tar.xz
6560b5d9e25758afc0c72a35374d6f8f  kholidays-6.17.0.tar.xz
6c40e376dae0209229739c9e92259964  purpose-6.17.0.tar.xz
60e2beddf625dd29b06ecb9966968824  kcalendarcore-6.17.0.tar.xz
76a127b6826b69f24a491c911d5f1731  kquickcharts-6.17.0.tar.xz
dad770e5aa4ad6b7c83625488c119619  knotifyconfig-6.17.0.tar.xz
2ef222252c3e1f9f131fe6d89ada580e  kdav-6.17.0.tar.xz
e60223dddf9812597933d37c9ced0003  kstatusnotifieritem-6.17.0.tar.xz
bd54e23c136fcb53ec866c476f1919c4  ksvg-6.17.0.tar.xz
242303b5dcdb5d4eab00c4d16980aec0  ktexttemplate-6.17.0.tar.xz
56e69133a11b2e67355d4869959be9ba  kuserfeedback-6.17.0.tar.xz
EOF""",
    f"""cd {builddir} && as_root()
{{
  if   [ $EUID = 0 ];        then $*
  elif [ -x /usr/bin/sudo ]; then sudo $*
  else                            su -c \\\\"$*\\\\"
  fi
}}

export -f as_root && mv -v /opt/kf6 /opt/kf6.old || true                         &&
install -v -dm755           $KF6_PREFIX/{{etc,share}} || true &&
ln -sfv /etc/dbus-1         $KF6_PREFIX/etc || true         &&
ln -sfv /usr/share/dbus-1   $KF6_PREFIX/share || true       &&
ln -sfv /usr/share/polkit-1 $KF6_PREFIX/share || true && while read -r line; do

    # Get the file name, ignoring comments and blank lines
    if $(echo $line | grep -E -q '^ *$|^#' ); then continue; fi
    file=$(echo $line | cut -d" " -f2)

    pkg=$(echo $file|sed 's|^.*/||')          # Remove directory
    packagedir=$(echo $pkg|sed 's|\\.tar.*||') # Package directory

    name=$(echo $pkg|sed 's|-6.*$||') # Isolate package name

    tar -xf $file
    pushd $packagedir

      # kapidox is a python module
      case $name in
        kapidox)
          pip3 wheel -w dist --no-build-isolation --no-deps --no-cache-dir $PWD
          as_root pip3 install --no-index --find-links dist --no-user kapidox
          popd
          rm -rf $packagedir
          continue
          ;;
      esac

      mkdir build
      cd    build

      cmake -D CMAKE_INSTALL_PREFIX=$KF6_PREFIX \\
            -D CMAKE_INSTALL_LIBEXECDIR=libexec \\
            -D CMAKE_PREFIX_PATH=$QT6DIR        \\
            -D CMAKE_SKIP_INSTALL_RPATH=ON      \\
            -D CMAKE_BUILD_TYPE=Release         \\
            -D BUILD_TESTING=OFF                \\
            -D BUILD_PYTHON_BINDINGS=OFF        \\
            -W no-dev ..
      make -j$(nproc)
      as_root make install
    popd

  as_root rm -rf $packagedir
  as_root /sbin/ldconfig

done < frameworks-{pkgver}.md5

exit""",
    f"cd {builddir} && rm -rf $KF6_PREFIX/lib/systemd || true && mv -v /opt/kf6 /opt/kf6-{pkgver} || true && ln -sfvn kf6-{pkgver} /opt/kf6 || true"

    # Cleanup
    f"rm -rf {builddir} {fembuilddir}"
]
