pkgname = "kmod"
pkgver  = "34.2" 
source  = f"http://localhost:8080/{pkgname}-{pkgver}.tar.xz"

deps = []

build = [
    # Extract
    f"cd /sources && tar -xvf {pkgname}-{pkgver}.tar.xz",

    # 64-bit build
    f"cd /sources/{pkgname}-{pkgver} && mkdir build && cd build",
    f"cd /sources/{pkgname}-{pkgver}/build && meson setup --prefix=/usr .. --buildtype=release -D manpages=false",
    f"cd /sources/{pkgname}-{pkgver}/build && ninja",
    f"cd /sources/{pkgname}-{pkgver}/build && ninja install",
    
    # 32-bit build
    f"cd /sources/{pkgname}-{pkgver}/ && rm -rf build && mkdir build",
    f"cd /sources/{pkgname}-{pkgver}/build && PKG_CONFIG_PATH=\"/usr/lib32/pkgconfig\" CC=\"gcc -m32 -march=i686\" CXX=\"g++ -m32 -march=i686\" meson setup --prefix=/usr .. --buildtype=release --libdir=/usr/lib32 -D manpages=false",
    f"cd /sources/{pkgname}-{pkgver}/build && ninja",
    f"cd /sources/{pkgname}-{pkgver}/build && DESTDIR=$PWD/DESTDIR ninja install",
    f"cd /sources/{pkgname}-{pkgver}/build && cp -Rv DESTDIR/usr/lib32/* /usr/lib32",
    f"cd /sources/{pkgname}-{pkgver}/build && rm -rf DESTDIR",

    # Cleanup
    f"rm -rf /sources/{pkgname}-{pkgver}"
]
