pkgname =  "libaom"
pkgver  = "3.13.1" 
source  = f"https://storage.googleapis.com/aom-releases/libaom-{pkgver}.tar.gz"
builddir = f"/tmp/fempkg/build/{pkgname}/{pkgname}-{pkgver}"
fembuilddir = f"/tmp/fempkg/build/{pkgname}"
deps = ["cmake"]

build = [
    # Extract
    f"mkdir /tmp/fempkg/build {fembuilddir} || true && cd {fembuilddir} && tar -xvf /var/lib/fempkg/pkgs/{pkgname}-{pkgver}.tar.gz",

    # 64-bit build
    f"cd {builddir} && mkdir aom-build && cd aom-build && cmake -D CMAKE_INSTALL_PREFIX=/usr -D CMAKE_BUILD_TYPE=Release -D BUILD_SHARED_LIBS=1 -D ENABLE_DOCS=no -G Ninja ..",
    f"cd {builddir}/aom-build && ninja",
    f"cd {builddir}/aom-build && ninja install && rm -v /usr/lib/libaom.a",

    # Cleanup
    f"rm -rf {builddir} {fembuilddir}"
]
