pkgname =  "libassuan"
pkgver  = "3.0.2" 
source  = f"https://www.gnupg.org/ftp/gcrypt/libassuan/libassuan-{pkgver}.tar.bz2"
builddir = f"/tmp/fempkg/build/{pkgname}/{pkgname}-{pkgver}"
fembuilddir = f"/tmp/fempkg/build/{pkgname}"
deps = ["libgpg-error"]

build = [
    # Extract
    f"mkdir /tmp/fempkg/build {fembuilddir} || true && cd {fembuilddir} && tar -xvf /var/lib/fempkg/pkgs/{pkgname}-{pkgver}.tar.bz2",

    # 64-bit build
    f"cd {builddir} && ./configure --prefix=/usr",
    f"cd {builddir} && make -j$(nproc) && make -C doc html && makeinfo --html --no-split -o doc/assuan_nochunks.html doc/assuan.texi && makeinfo --plaintext -o doc/assuan.txt doc/assuan.texi",
    f"cd {builddir} && make install && install -v -dm755 /usr/share/doc/libassuan-{pkgver}/html && install -v -m644 doc/assuan.html/* /usr/share/doc/libassuan-{pkgver}/html && install -v -m644 doc/assuan_nochunks.html /usr/share/doc/libassuan-{pkgver} && install -v -m644 doc/assuan.{{txt,texi}} /usr/share/doc/libassuan-{pkgver}",

    # Cleanup
    f"rm -rf {builddir} {fembuilddir}"
]
