pkgname =  "libblockdev"
pkgver  = "3.4.0" 
source  = f"https://github.com/storaged-project/libblockdev/releases/download/{pkgver}/libblockdev-{pkgver}.tar.gz"
builddir = f"/tmp/fempkg/build/{pkgname}/{pkgname}-{pkgver}"
fembuilddir = f"/tmp/fempkg/build/{pkgname}"
deps = ["glib", "cryptsetup", "keyutils", "libatasmart", "libbytesize", "libnvme", "LVM2"]

build = [
    # Extract
    f"mkdir /tmp/fempkg/build {fembuilddir} || true && cd {fembuilddir} && tar -xvf /var/lib/fempkg/pkgs/{pkgname}-{pkgver}.tar.gz",

    # 64-bit build
    f"cd {builddir} && ./configure --prefix=/usr --sysconfdir=/etc --with-python3 --without-escrow --without-gtk-doc --without-lvm --without-lvm_dbus --without-nvdimm --without-tools --without-smartmontools",
    f"cd {builddir} && make -j$(nproc)",
    f"cd {builddir} && make install",

    # Cleanup
    f"rm -rf {builddir} {fembuilddir}"
]
