pkgname =  "libcanberra"
pkgver  = "0.30" 
source  = f"https://0pointer.de/lennart/projects/libcanberra/libcanberra-{pkgver}.tar.xz"
builddir = f"/tmp/fempkg/build/{pkgname}/{pkgname}-{pkgver}"
fembuilddir = f"/tmp/fempkg/build/{pkgname}"
deps = ["libvorbis", "alsa-lib", "gstreamer", "gtk3"]

build = [
    # Extract
    f"mkdir /tmp/fempkg/build {fembuilddir} || true && cd {fembuilddir} && tar -xvf /var/lib/fempkg/pkgs/{pkgname}-{pkgver}.tar.xz && wget https://www.linuxfromscratch.org/patches/blfs/svn/libcanberra-{pkgver}-wayland-1.patch",

    # 64-bit build
    f"cd {builddir} && patch -Np1 -i ../libcanberra-{pkgver}-wayland-1.patch && ./configure --prefix=/usr --disable-oss",
    f"cd {builddir} && make -j$(nproc)",
    f"cd {builddir} && make docdir=/usr/share/doc/libcanberra-{pkgver} install",

    # Cleanup
    f"rm -rf {builddir} {fembuilddir}"
]
