pkgname = "libcap"
pkgver  = "2.76"
source  = f"http://localhost:8080/{pkgname}-{pkgver}.tar.xz"

deps = []

build = [
    # Extract
    f"cd /sources && tar -xvf {pkgname}-{pkgver}.tar.xz",

    # 64-bit build
    f"cd /sources/{pkgname}-{pkgver} && sed -i '/install -m.*STA/d' libcap/Makefile",
    f"cd /sources/{pkgname}-{pkgver} && make prefix=/usr lib=lib -j$(nproc)",
    f"cd /sources/{pkgname}-{pkgver} && make test -j$(nproc) || true",
    f"cd /sources/{pkgname}-{pkgver} && make prefix=/usr lib=lib install",

    # 32-bit build
    f"cd /sources/{pkgname}-{pkgver} && make distclean",
    f"cd /sources/{pkgname}-{pkgver} && make CC=\"gcc -m32 -march=i686\"",
    f"cd /sources/{pkgname}-{pkgver} && make CC=\"gcc -m32 -march=i686\" lib=lib32 prefix=$PWD/DESTDIR/usr -C libcap install",
    f"cd /sources/{pkgname}-{pkgver} && cp -Rv DESTDIR/usr/lib32/* /usr/lib32",
    f"cd /sources/{pkgname}-{pkgver} && sed -e \"s|^libdir=.*|libdir=/usr/lib32|\" -i /usr/lib32/pkgconfig/lib{{cap,psx}}.pc",
    f"cd /sources/{pkgname}-{pkgver} && chmod -v 755 /usr/lib32/libcap.so.{pkgver} && rm -rf DESTDIR",

    # Cleanup
    f"rm -rf /sources/{pkgname}-{pkgver}"
]
