pkgname = "libclc"
pkgver  = "21.1.2"
source  = f"https://github.com/llvm/llvm-project/releases/download/llvmorg-{pkgver}/libclc-{pkgver}.src.tar.xz"
builddir = f"/tmp/fempkg/build/{pkgname}/libclc-{pkgver}.src"
fembuilddir = f"/tmp/fempkg/build/{pkgname}"
deps = ["llvm", "spirv-llvm-translator"]

build = [
    # Extract
    f"mkdir -p /tmp/fempkg/build {fembuilddir} || true && cd {fembuilddir} && "
    f"tar -xvf /var/lib/fempkg/pkgs/libclc-{pkgver}.src.tar.xz",

    # Configure
    f"cd {builddir} && rm -rf build && mkdir build && cd build && cmake "
    f"-D CMAKE_INSTALL_PREFIX=/usr "
    f"-D CMAKE_BUILD_TYPE=Release "
    f"-DLLVM_DIR=/usr/lib/cmake/llvm "
    f"-G Ninja ..",

    # Build + install
    f"cd {builddir}/build && ninja",
    f"cd {builddir}/build && ninja install",

    # Cleanup
    f"rm -rf {builddir} {fembuilddir}"
]
