pkgname = "libelf"
pkgver  = "0.193" 
source  = f"http://localhost:8080/elfutils-{pkgver}.tar.bz2"

deps = []

build = [
    # Extract
    f"cd /sources && tar -xvf elfutils-{pkgver}.tar.bz2",

    # 64-bit build
    f"cd /sources/elfutils-{pkgver} && ./configure --prefix=/usr --disable-debuginfod --enable-libdebuginfod=dummy",
    f"cd /sources/elfutils-{pkgver} && make -j$(nproc)",
    f"cd /sources/elfutils-{pkgver} && make -C libelf install",
    f"cd /sources/elfutils-{pkgver} && install -vm644 config/libelf.pc /usr/lib/pkgconfig || true",
    f"cd /sources/elfutils-{pkgver} && rm /usr/lib/libelf.a || true",

    # 32-bit build
    f"cd /sources/elfutils-{pkgver} && make distclean",
    f"cd /sources/elfutils-{pkgver} && CC=\"gcc -m32\" CXX=\"g++ -m32\" ./configure --host=i686-pc-linux-gnu --prefix=/usr --libdir=/usr/lib32 --disable-debuginfod --enable-libdebuginfod=dummy",
    f"cd /sources/elfutils-{pkgver} && make -j$(nproc)",
    f"cd /sources/elfutils-{pkgver} && make DESTDIR=$PWD/DESTDIR -C libelf install",
    f"cd /sources/elfutils-{pkgver} && install -vDm644 config/libelf.pc DESTDIR/usr/lib32/pkgconfig/libelf.pc || true",
    f"cd /sources/elfutils-{pkgver} && cp -Rv DESTDIR/usr/lib32/* /usr/lib32 || true",
    f"cd /sources/elfutils-{pkgver} && rm -rf DESTDIR",

    # Cleanup
    f"rm -rf /sources/elfutils-{pkgver}"
]
