pkgname =  "libgcrypt"
pkgver  = "1.11.2" 
source  = f"https://www.gnupg.org/ftp/gcrypt/libgcrypt/libgcrypt-{pkgver}.tar.bz2"
builddir = f"/tmp/fempkg/build/{pkgname}/{pkgname}-{pkgver}"
fembuilddir = f"/tmp/fempkg/build/{pkgname}"
deps = ["libgpg-error"]

build = [
    # Extract
    f"mkdir /tmp/fempkg/build {fembuilddir} || true && cd {fembuilddir} && tar -xvf /var/lib/fempkg/pkgs/{pkgname}-{pkgver}.tar.bz2",

    # 64-bit build
    f"cd {builddir} && ./configure --prefix=/usr",
    f"cd {builddir} && make -j$(nproc) && make -C doc html && makeinfo --html --no-split -o doc/gcrypt_nochunks.html doc/gcrypt.texi && makeinfo --plaintext -o doc/gcrypt.txt doc/gcrypt.texi",
    f"cd {builddir} && make install && install -v -dm755 /usr/share/doc/libgcrypt-{pkgver} && install -v -m644 README doc/{{README.apichanges,fips*,libgcrypt*}} /usr/share/doc/libgcrypt-{pkgver} && install -v -dm755 /usr/share/doc/libgcrypt-{pkgver}/html && install -v -m644 doc/gcrypt.html/* /usr/share/doc/libgcrypt-{pkgver}/html && install -v -m644 doc/gcrypt_nochunks.html /usr/share/doc/libgcrypt-{pkgver} && install -v -m644 doc/gcrypt.{{txt,texi}} /usr/share/doc/libgcrypt-{pkgver}",

    # Cleanup
    f"rm -rf {builddir} {fembuilddir}"
]
