pkgname =  "libglvnd"
pkgver  = "1.7.0" 
source  = f"https://gitlab.freedesktop.org/glvnd/libglvnd/-/archive/v{pkgver}/libglvnd-v{pkgver}.tar.gz"
builddir = f"/tmp/fempkg/build/{pkgname}/{pkgname}-v{pkgver}"
fembuilddir = f"/tmp/fempkg/build/{pkgname}"
deps = []

build = [
    # Extract
    f"mkdir /tmp/fempkg/build {fembuilddir} || true && cd {fembuilddir} && tar -xvf /var/lib/fempkg/pkgs/{pkgname}-v{pkgver}.tar.gz",

    # 64-bit build
    f"cd {builddir} && mkdir build && cd build && meson setup .. --prefix=/usr --buildtype=release -D gles1=false -D hgl=false",
    f"cd {builddir}/build && ninja",
    f"cd {builddir}/build && ninja install",

    # 32-bit build
    f"cd {builddir}/build && rm -rf * && CC=\"gcc -m32\" CXX=\"g++ -m32\" PKG_CONFIG_PATH=/usr/lib32/pkgconfig meson setup .. --prefix=/usr --libdir=/usr/lib32 --buildtype=release -D gles1=false -D hgl=false",
    f"cd {builddir}/build && ninja",
    f"cd {builddir}/build && DESTDIR=$PWD/DESTDIR ninja install",
    f"cd {builddir}/build && cp -vr DESTDIR/usr/lib32/* /usr/lib32",
    f"cd {builddir}/build && rm -rf DESTDIR",
    f"cd {builddir}/build && ldconfig",

    # Cleanup
    f"rm -rf {builddir} {fembuilddir}"
]
