pkgname =  "libgweather"
pkgver  = "4.4.4" 
source  = f"https://download.gnome.org/sources/libgweather/4.4/libgweather-{pkgver}.tar.xz"
builddir = f"/tmp/fempkg/build/{pkgname}/{pkgname}-{pkgver}"
fembuilddir = f"/tmp/fempkg/build/{pkgname}"
deps = ["geocode-glib", "glib", "gtk3", "libsoup", "pygobject", "libxml2", "vala"]

build = [
    # Extract
    f"mkdir /tmp/fempkg/build {fembuilddir} || true && cd {fembuilddir} && tar -xvf /var/lib/fempkg/pkgs/{pkgname}-{pkgver}.tar.xz && wget  https://www.linuxfromscratch.org/patches/blfs/svn/libgweather-{pkgver}-upstream_fix-1.patch",

    # 64-bit build
    f"cd {builddir} && patch -Np1 -i ../libgweather-{pkgver}-upstream_fix-1.patch && mkdir build && cd build && meson setup --prefix=/usr --buildtype=release -D gtk_doc=false ..",
    f"cd {builddir}/build && ninja",
    f"cd {builddir}/build && ninja install",

    # Cleanup
    f"rm -rf {builddir} {fembuilddir}"
]
