pkgname =  "libical"
pkgver  = "3.0.20" 
source  = f"https://github.com/libical/libical/releases/download/v{pkgver}/libical-{pkgver}.tar.gz"
builddir = f"/tmp/fempkg/build/{pkgname}/{pkgname}-{pkgver}"
fembuilddir = f"/tmp/fempkg/build/{pkgname}"
deps = ["glib", "vala"]

build = [
    # Extract
    f"mkdir /tmp/fempkg/build {fembuilddir} || true && cd {fembuilddir} && tar -xvf /var/lib/fempkg/pkgs/{pkgname}-{pkgver}.tar.gz",

    # 64-bit build
    f"cd {builddir} && mkdir build && cd build && cmake -D CMAKE_INSTALL_PREFIX=/usr -D CMAKE_BUILD_TYPE=Release -D SHARED_ONLY=yes -D ICAL_BUILD_DOCS=false -D GOBJECT_INTROSPECTION=true -D ICAL_GLIB_VAPI=true ..",
    f"cd {builddir}/build && make -j$(nproc)",
    f"cd {builddir}/build && make install && install -vdm755 /usr/share/doc/libical-{pkgver}/html || true && cp -vr apidocs/html/* /usr/share/doc/libical-{pkgver}/html || true",

    # Cleanup
    f"rm -rf {builddir} {fembuilddir}"
]
