pkgname =  "libinput"
pkgver  = "1.29.2" 
source  = f"https://gitlab.freedesktop.org/libinput/libinput/-/archive/{pkgver}/libinput-{pkgver}.tar.gz"
builddir = f"/tmp/fempkg/build/{pkgname}/{pkgname}-{pkgver}"
fembuilddir = f"/tmp/fempkg/build/{pkgname}"
deps = ["libevdev",  "mtdev"]

build = [
    # Extract
    f"mkdir /tmp/fempkg/build {fembuilddir} || true && cd {fembuilddir} && tar -xvf /var/lib/fempkg/pkgs/{pkgname}-{pkgver}.tar.gz",

    # 64-bit build
    f"cd {builddir} && mkdir build && cd build && meson setup .. --prefix=/usr --buildtype=release -D debug-gui=false -D tests=false -D libwacom=false -D udev-dir=/usr/lib/udev",
    f"cd {builddir}/build && ninja",
    f"cd {builddir}/build && ninja install",

    # Cleanup
    f"rm -rf {builddir} {fembuilddir}"
]
