pkgname =  "libjpeg-turbo"
pkgver  = "3.0.1" 
source  = f"https://downloads.sourceforge.net/libjpeg-turbo/libjpeg-turbo-{pkgver}.tar.gz"
builddir = f"/tmp/fempkg/build/{pkgname}/{pkgname}-{pkgver}"
fembuilddir = f"/tmp/fempkg/build/{pkgname}"
deps = ["cmake", "yasm"]

build = [
    # Extract
    f"mkdir /tmp/fempkg/build {fembuilddir} || true && cd {fembuilddir} && tar -xvf /var/lib/fempkg/pkgs/{pkgname}-{pkgver}.tar.gz",

    # 64-bit build
    f"cd {builddir} && mkdir build && cd build && cmake -D CMAKE_INSTALL_PREFIX=/usr -D CMAKE_BUILD_TYPE=RELEASE -D ENABLE_STATIC=FALSE -D CMAKE_INSTALL_DEFAULT_LIBDIR=lib -D CMAKE_POLICY_VERSION_MINIMUM=3.5 -D CMAKE_SKIP_INSTALL_RPATH=ON -D CMAKE_INSTALL_DOCDIR=/usr/share/doc/libjpeg-turbo-{pkgver} ..",
    f"cd {builddir}/build && make",
    f"cd {builddir}/build && make install",

    # Cleanup
    f"rm -rf {builddir} {fembuilddir}"
]
