pkgname =  "libjxl"
pkgver  = "0.11.1" 
source  = f"https://github.com/libjxl/libjxl/archive/v{pkgver}/libjxl-{pkgver}.tar.gz"
builddir = f"/tmp/fempkg/build/{pkgname}/{pkgname}-{pkgver}"
fembuilddir = f"/tmp/fempkg/build/{pkgname}"
deps = ["brotli", "cmake", "giflib", "highway", "lcms2", "libjpeg-turbo", "libpng", "gdkpixbuf"]

build = [
    # Extract
    f"mkdir /tmp/fempkg/build {fembuilddir} || true && cd {fembuilddir} && tar -xvf /var/lib/fempkg/pkgs/{pkgname}-{pkgver}.tar.gz",

    # 64-bit build
    f"cd {builddir} && mkdir build && cd build && cmake -D CMAKE_INSTALL_PREFIX=/usr -D CMAKE_BUILD_TYPE=Release -D BUILD_TESTING=OFF -D BUILD_SHARED_LIBS=ON -D JPEGXL_ENABLE_SKCMS=OFF -D JPEGXL_ENABLE_SJPEG=OFF -D JPEGXL_ENABLE_PLUGINS=ON -D JPEGXL_INSTALL_JARDIR=/usr/share/java -G Ninja ..",
    f"cd {builddir}/build && ninja",
    f"cd {builddir}/build && ninja install && gdk-pixbuf-query-loaders --update-cache",

    # Cleanup
    f"rm -rf {builddir} {fembuilddir}"
]
