pkgname =  "libkcddb"
pkgver  = "25.08.0" 
source  = f"https://download.kde.org/stable/release-service/{pkgver}/src/libkcddb-{pkgver}.tar.xz"
builddir = f"/tmp/fempkg/build/{pkgname}/{pkgname}-{pkgver}"
fembuilddir = f"/tmp/fempkg/build/{pkgname}"
deps = ["kf6", "libmusicbrainz"]

build = [
    # Extract
    f"mkdir /tmp/fempkg/build {fembuilddir} || true && cd {fembuilddir} && tar -xvf /var/lib/fempkg/pkgs/{pkgname}-{pkgver}.tar.xz",

    # 64-bit build
    f"cd {builddir} && mkdir build && cd build && cmake -D CMAKE_INSTALL_PREFIX=$KF6_PREFIX -D CMAKE_BUILD_TYPE=Release -D BUILD_TESTING=OFF -D QT_MAJOR_VERSION=6 -W no-dev ..",
    f"cd {builddir}/build && make -j$(nproc)",
    f"cd {builddir}/build && make install",

    # Cleanup
    f"rm -rf {builddir} {fembuilddir}"
]
