pkgname =  "libliftoff"
pkgver  = "0.5.0" 
source  = f"https://gitlab.freedesktop.org/emersion/libliftoff/-/archive/v{pkgver}/libliftoff-v{pkgver}.tar.gz"
builddir = f"/tmp/fempkg/build/{pkgname}/{pkgname}-v{pkgver}"
fembuilddir = f"/tmp/fempkg/build/{pkgname}"
deps = ["libdrm"]

build = [
    # Extract
    f"mkdir /tmp/fempkg/build {fembuilddir} || true && cd {fembuilddir} && tar -xvf /var/lib/fempkg/pkgs/{pkgname}-v{pkgver}.tar.gz",

    # 64-bit build
    f"cd {builddir} && mkdir build && cd build && meson setup --prefix=/usr --buildtype=release ..",
    f"cd {builddir}/build && ninja",
    f"cd {builddir}/build && ninja install",

    # Cleanup
    f"rm -rf {builddir} {fembuilddir}"
]
