pkgname =  "libmad"
pkgver  = "0.15.1b" 
source  = f"https://downloads.sourceforge.net/mad/libmad-{pkgver}.tar.gz"
builddir = f"/tmp/fempkg/build/{pkgname}/{pkgname}-{pkgver}"
fembuilddir = f"/tmp/fempkg/build/{pkgname}"
deps = []

build = [
    # Extract
    f"mkdir /tmp/fempkg/build {fembuilddir} || true && cd {fembuilddir} && tar -xvf /var/lib/fempkg/pkgs/{pkgname}-{pkgver}.tar.gz && wget https://www.linuxfromscratch.org/patches/blfs/svn/libmad-{pkgver}-fixes-1.patch",

    # 64-bit build
    f"""cd {builddir} && patch -Np1 -i ../libmad-{pkgver}-fixes-1.patch                &&
sed "s@AM_CONFIG_HEADER@AC_CONFIG_HEADERS@g" -i configure.ac &&
touch NEWS AUTHORS ChangeLog                                 &&
autoreconf -fi                                               &&

./configure --prefix=/usr --disable-static""",
    f"cd {builddir} && make -j$(nproc)",
    f"""cd {builddir} && make install && cat > /usr/lib/pkgconfig/mad.pc << "EOF"
prefix=/usr
exec_prefix=${{prefix}}
libdir=${{exec_prefix}}/lib
includedir=${{prefix}}/include

Name: mad
Description: MPEG audio decoder
Requires:
Version: {pkgver}
Libs: -L${{libdir}} -lmad
Cflags: -I${{includedir}}
EOF""",

    # Cleanup
    f"rm -rf {builddir} {fembuilddir}"
]
