pkgname =  "libmusicbrainz"
pkgver  = "5.1.0" 
source  = f"https://github.com/metabrainz/libmusicbrainz/releases/download/release-{pkgver}/libmusicbrainz-{pkgver}.tar.gz"
builddir = f"/tmp/fempkg/build/{pkgname}/{pkgname}-{pkgver}"
fembuilddir = f"/tmp/fempkg/build/{pkgname}"
deps = ["cmake", "libxml2", "neon"]

build = [
    # Extract
    f"mkdir /tmp/fempkg/build {fembuilddir} || true && cd {fembuilddir} && tar -xvf /var/lib/fempkg/pkgs/{pkgname}-{pkgver}.tar.gz && wget https://www.linuxfromscratch.org/patches/blfs/svn/libmusicbrainz-{pkgver}-cmake_fixes-1.patch",

    # 64-bit build
    f"cd {builddir} && patch -Np1 -i ../libmusicbrainz-{pkgver}-cmake_fixes-1.patch && sed -e 's/xmlErrorPtr /const xmlError */' -i src/xmlParser.cc && mkdir build && cd build && cmake -D CMAKE_INSTALL_PREFIX=/usr -D CMAKE_BUILD_TYPE=Release -D CMAKE_POLICY_VERSION_MINIMUM=3.5 ..",
    f"cd {builddir}/build && make -j$(nrpoc)",
    f"cd {builddir}/build && make install",

    # Cleanup
    f"rm -rf {builddir} {fembuilddir}"
]
