pkgname =  "libnotify"
pkgver  = "0.8.7" 
source  = f"https://download.gnome.org/sources/libnotify/0.8/libnotify-{pkgver}.tar.xz"
builddir = f"/tmp/fempkg/build/{pkgname}/{pkgname}-{pkgver}"
fembuilddir = f"/tmp/fempkg/build/{pkgname}"
deps = ["gtk3", "glib"]

build = [
    # Extract
    f"mkdir /tmp/fempkg/build {fembuilddir} || true && cd {fembuilddir} && tar -xvf /var/lib/fempkg/pkgs/{pkgname}-{pkgver}.tar.xz",

    # 64-bit build
    f"cd {builddir} && mkdir build && cd build && meson setup --prefix=/usr --buildtype=release -D gtk_doc=false -D man=false ..",
    f"cd {builddir}/build && ninja",
    f"cd {builddir}/build && ninja install && if [ -e /usr/share/doc/libnotify ]; then rm -rf /usr/share/doc/libnotify-{pkgver}; mv -v /usr/share/doc/libnotify{{,-{pkgver}}}; fi",

    # Cleanup
    f"rm -rf {builddir} {fembuilddir}"
]
